
  ' Started....18-12-24
' Microcontroller used:  Microchip Technology PIC16F1455
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com     

'--------Program Desciption--------
' Software to control motor using DRV8871 motor driver 
'To conserve power when the train is stopped the motor driver is placed in
' sleep mode, set by variable d
' 
 

#CONFIG
        __config _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF & _IESO_OFF & _FCMEN_OFF
        __config _CONFIG2, _FCMEN_OFF & _PLLEN_DISABLED & _LVP_OFF
#ENDCONFIG
                                                                
  
 
  
 OSCCON = %00110110   '4mhz int osc
 OSCTUNE = %00000000 
 define OSC 4
 Define SER2_BITS 8     
OPTION_REG.7 = 1 ' PORT A&B Pull-Ups disabled 
INTCON.7 = 0 ' disable external interrupts
INTCON.6 = 0 'disable pher interrupts    
ADCON0 = %00001111    ' A/D Module on analogue 3(RA4) selected

ADCON1 = %11010000' Vref connected to +5V right justified

FVRCON.7 = 0 'Vref module off
define ADC_BITS 10 'set number of bits in result as 10
define  ADC_CLOCK    3     ' Set clock source (3=rc)
Define  ADC_SAMPLEUS 50    ' Set sampling time in uS    
DACCON0.7 = 0  'DAC off



T1CON.0 = 0 'timer 1 off
CM1CON0    = %00000000 ' Comparator1 Module is OFF
CM2CON0    = %00000000 ' Comparator2 Module is OFF
UCON.3 = 0  'USB off 
UCON.1 = 1  'USB module in power conserve
SSPCON1.5 = 0 'disable serial ports  
WPUA       = %00000000 'weak pull ups disabled



APFCON.2 = 0 'PWM2 output on RC3
TRISA      = %00011111 ' RA0,RA1,No RA2,RA3 MCRL,RA4 rest outputs
ANSELA     = %00010000 'RA4 analogue rest digital 
TRISC      = %00000100 ' RC2 input rest outputs                                                                                          
ANSELC     = %00000000 ' all digital 

 
  a var byte 'second check byte (has to be 30)
  b var byte 'Motor speed
  c var byte 'Forward reverse ( 5 forward 7 reverse)
  d var byte 'Minimum speed that switches motor driver into low current mode
  e var word 'minimum batttery voltage
  f var byte'first check byte ( has to be 38)
  X var word 'measured battery voltage
   '----------Initialization---------
   
   a = 0
   b = 0 'motor stopped
   c = 0 '
   d = 15
   e = 410 '2V 410 4 batteries
   f = 0
   x = 500 
   RUN:
 PORTC.4 = 1 'LED off
 PWM2CON.7 = 0 'PWM 2 is off
 PWM2CON.6 = 0  'PWM 2 output disable
 PORTC.3 = 0
 PWM1CON.7 = 0 'PWM 1 is off
 PWM1CON.6 = 0  'PWM 1 output disable 
 PORTC.5 = 0
 pause 300
 
 Start: 
  ADCIN 3,x
 if x < e then PORTC.4 = 0    'battery voltage less than 2V charge light on
 if x = e then PORTC.4 = 0    'battery voltage equal to 2V charge light on
 if x > e then PORTC.4 = 1    'battery voltage greater than 2V charge light off 
 
 serin2 PORTC.2,1091,[wait("A"),f,b,c,a] 'receive serial data wait until ASCI char A 
 'is received then write data in variables a,b,c and f

 
  pauseus 100
  
if f > 38 then goto Start 'f received value not 38 (corrupted data)
if F < 38 then goto Start 'f received value not 38 (corrupted data)
if F = 38 then goto proceed1 'f received value 38) (correct data)
proceed1

 if a > 30 then goto start 'a received value not 30 (corrupted data)
 if a < 30 then goto Start 'a received value not 30 (corrupted data)
if a = 30 then goto proceed 'a received value 30 (correct data)
 
 
 proceed:

 if C < 5 then goto Start ' incorrect value for c received (corrupted data)
 if C > 10 then goto Start ' incorrect value for c received (corrupted data)
 if c < 10 and c > 5 then goto Start' incorrect value for c received (corrupted)
 if C = 5 then goto Fwd  
 if c = 10 then goto Reve
 
 Lowi: 'Motor driver sleep
 PWM2CON.7 = 0 'PWM 2 is off
 PWM2CON.6 = 0  'PWM 2 output disable
 PORTC.3 = 0
 PWM1CON.7 = 0 'PWM 1 is off
 PWM1CON.6 = 0  'PWM 1 output disable 
 PORTC.5 = 0   

 goto Start   
 
 Fwd: 
 if B < d then goto lowi ' lowi switches motor driver to low current mode
 PWM1CON.7 = 0 'PWM 1 is off
 PWM1CON.6 = 0  'PWM 1 output disable 
 PORTC.5 = 1
 PWM2CON.4 = 1  'output active high, PWM 100% when Tx speed pot at maximum 
 HPWM 2,b,7000 'PWM to portC3 normally 7000  
 
 goto Start
 
 Reve:  
 if B < d then goto lowi ' lowi switches motor driver to low current mode
 PWM2CON.7 = 0 'PWM 2 is off
 PWM2CON.6 = 0  'PWM 2 output disable 
 PORTC.3 = 1
 PWM1CON.4 = 1  'output active high, PWM 100% when Tx speed pot at maximum  
 HPWM 1,b,7000 'PWM to portC5 normally 7000 

 goto Start


